<%@ Application Language="VB" %>
<%@ Import Namespace="System.Net.Mail"%>

<script RunAt="server">

  Sub Application_Start(ByVal sender As Object, ByVal e As EventArgs)
    ' Kod uruchamiany przy starcie aplikacji
  End Sub
    
  Sub Application_End(ByVal sender As Object, ByVal e As EventArgs)
    ' Kod uruchamiany przy zamykaniu aplikacji
  End Sub
        
  Sub Application_Error(ByVal sender As Object, ByVal e As EventArgs)
    ' Uruchamia si w razie wystpienia bdu
    If AppConfiguration.SendMailOnErrors Then
      Dim subject As String = "Error in page " & Request.Url.ToString()
      Dim errorMessage As StringBuilder = New StringBuilder
      ' Bd, ktry wystpi na stronie www jest opakowywany w standardowy wyjtek System.Web.HttpUnhandledException
      ' Dlatego musimy si dosta do prawdziwego wyjtku, dostpnego jako InnerException
      Dim myException As Exception = HttpContext.Current.Server.GetLastError()
      If myException IsNot Nothing Then
        Do While myException IsNot Nothing
          errorMessage.Append("<strong>Komunikat</strong><br />" & _
              myException.Message & "<br /><br />")
          errorMessage.Append("<strong>rdo</strong><br />" & _
              myException.Source & "<br /><br />")
          errorMessage.Append("<strong>Strona wyjciowa</strong><br />" & _
              myException.TargetSite.ToString() & "<br /><br />")
          errorMessage.Append("<strong>ledzenie stosu</strong><br />" & _
              myException.StackTrace & "<br /><br />")
          errorMessage.Append("<strong>ToString()</strong><br />" & _
              myException.ToString() & "<br /><br />")
          myException = myException.InnerException
        Loop
      Else
        errorMessage.Append("Brak informacji o wyjtku.")
      End If

      ' Po skomponowaniu errorMessage, wylij wiadomo e-mail.
      Dim mySmtpClient As SmtpClient = New SmtpClient()
      Dim myMessage As MailMessage = New MailMessage( _
          AppConfiguration.EmailFromAddressForErrors, AppConfiguration.EmailToAddressForErrors, subject, _
          errorMessage.ToString())
      myMessage.IsBodyHtml = True

      mySmtpClient.Send(myMessage)
    End If
  End Sub

  Sub Session_Start(ByVal sender As Object, ByVal e As EventArgs)
    ' Kod uruchamiany po rozpoczciu nowej sesji
  End Sub

  Sub Session_End(ByVal sender As Object, ByVal e As EventArgs)
    ' Kod uruchamiany, kiedy sesja koczy si.
    ' Uwaga: Zdarzenie Session_End jest wywoywane tylko wwczas gdy tryb stanu sesji
    ' jest ustawiony na InProc w pliku Web.config. Jeli tryb sesji jest ustawiony na StateServer
    ' lub SQLServer zdarzenie nie jest wywoywane.
  End Sub
       
</script>

